/*======================================================================*\
|| #################################################################### ||
|| # vBulletin 3.6.4
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2000-2006 Jelsoft Enterprises Ltd. All Rights Reserved. ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/

/**
* Adds onclick events to appropriate elements for submitting the form
*
* @param	string	The ID of the form that contains the ignore list elements
* @param	string	The ID of the form that contains the buddy list elements
*/
function vB_AJAX_Userlist_Init(ignoreformid, buddyformid)
{
	// this can count as a "problematic" AJAX function, as usernames won't be found without iconv
	if (AJAX_Compatible && (typeof vb_disable_ajax == 'undefined' || vb_disable_ajax == 0))
	{
		if (typeof(document.forms.userlist_buddyform) != 'undefined')
		{
			document.forms.userlist_buddyform.onsubmit = vB_AJAX_Userlist.prototype.form_click;
		}
		if (typeof(document.forms.userlist_ignoreform) != 'undefined')
		{
			document.forms.userlist_ignoreform.onsubmit = vB_AJAX_Userlist.prototype.form_click;
		}
	}
};

/**
* Class to handle userlist modifications
*
* @param	object	The form object containing the list elements
*/
function vB_AJAX_Userlist(formobj)
{
	// AJAX handler
	this.xml_sender = null;

	// vB_Hidden_Form object to handle form variables
	this.pseudoform = new vB_Hidden_Form('profile.php');
	this.pseudoform.add_variable('ajax', 1);
	this.pseudoform.add_variables_from_object(formobj);

	this.list = this.pseudoform.fetch_variable('userlist');

	// Closure
	var me = this;

	/**
	* OnReadyStateChange callback. Uses a closure to keep state.
	* Remember to use me instead of this inside this function!
	*/
	this.handle_ajax_response = function()
	{
		if (me.xml_sender.handler.readyState == 4 && me.xml_sender.handler.status == 200)
		{
			if (me.xml_sender.handler.responseXML)
			{
				// check for error first
				var error = me.xml_sender.fetch_data(fetch_tags(me.xml_sender.handler.responseXML, 'error')[0]);
				if (error)
				{
					// show error
					fetch_object('userfield_' + me.list + '_errortext').innerHTML = error;
					fetch_object('userfield_' + me.list + '_error').style.display = '';
				}
				else
				{
					// hide error
					fetch_object('userfield_' + me.list + '_error').style.display = 'none';

					fetch_object('userfield_' + me.list + '_txt').value = '';
					fetch_object(me.list + 'list1').innerHTML = me.xml_sender.fetch_data(fetch_tags(me.xml_sender.handler.responseXML, 'listbit1')[0]);
					fetch_object(me.list + 'list2').innerHTML = me.xml_sender.fetch_data(fetch_tags(me.xml_sender.handler.responseXML, 'listbit2')[0]);
				}
			}

			if (is_ie)
			{
				me.xml_sender.handler.abort();
			}
		}
	}
};

/**
* Submit the form
*/
vB_AJAX_Userlist.prototype.submit = function()
{
	this.xml_sender = new vB_AJAX_Handler(true);
	this.xml_sender.onreadystatechange(this.handle_ajax_response);
	this.xml_sender.send(
		'profile.php?do=updatelist&userlist=' + PHP.urlencode(this.list),
		this.pseudoform.build_query_string()
	);
};

/**
* Handles the form 'submit' action
*/
vB_AJAX_Userlist.prototype.form_click = function()
{
	var AJAX_Userlist = new vB_AJAX_Userlist(this);
	AJAX_Userlist.submit();
	return false;
};

/*======================================================================*\
|| ####################################################################
|| # Downloaded: DGT-DATE
|| # CVS: $RCSfile$ - $Revision: 15437 $
|| ####################################################################
\*======================================================================*/